define([
    'underscore',
    'backbone',
    'moment',
    'modules/new-appointment-request/views/common/confirmation-modal/popup-view',
], function(_, Backbone, moment, ConfirmAppointmentPopupView) {
    'use strict';


    describe('Confirm Appointment Popup', function() {
        var view;
        var $view;

        var VIDEO_STOP_CODE = '179';

        var getAppointmentModelForSubmit = function(clinic) {
            return new Backbone.Model({
                apptLength: 30,
                clinic: new Backbone.Model(clinic),
                direct: {
                    dateTime: moment('02/21/2017 09:30:00'),
                    desiredDate: 'OTHER_THAN_NEXT_AVAILABLE_PATIENT_REQUESTED',
                },
                facility: new Backbone.Model({
                    address: '150 SOUTH HUNTINGTON AVENUE',
                    city: 'BOSTON',
                    facilityCode: '523',
                    name: 'BOSTON HCS VAMC',
                    institutionTimezone: 'America/New_York',
                }),
                purpose: 'Purpose is not displayed in popup',
                typeOfCare: '323',
            });
        };

        describe('for TRADITIONAL appointments', function() {
            beforeEach(function() {
                view = new ConfirmAppointmentPopupView({
                    model: getAppointmentModelForSubmit({
                        clinicFriendlyLocationName: "Dr. Evan's Clinic friendly name",
                        clinicId: '123',
                        clinicName: 'MOCK CLINIC NAME 123',
                        secondaryStopCode: '',
                    }),
                    typeOfCareName: 'PRIMARY CARE',
                    notificationEmail: 'abc@edf.com',
                    elAfterClose: '.element-for-focus',
                });

                $('body').append('<a class="element-for-focus" href="#"></a>');
                view.render();
                $view = view.$el;
            });

            afterEach(function() {
                view.destroy();
                $('.element-for-focus').remove();
            });

            it('has a heading', function() {
                expect($view.find('h3.ui-title').text()).toEqual('Confirm Appointment');
            });

            it('has displays appointment summary and video appointment instructions', function() {
                var expectedTime = "02/21/2017 @ 0930 EST\nType of Care: PRIMARY CARE\nBOSTON HCS VAMC\nMOCK CLINIC NAME 123\nDr. Evan's Clinic friendly name";

                expect($view.find('.ui-content p:first-child').text()).toEqual('You are scheduling an In-Person Appointment for:');
                expect($view.find('.ui-content p:nth-child(2)').text()
                    .replace(/[\t\f\v]/g, '')).toEqual(expectedTime);
            });
        });

        describe('for MOBILE_ANY appointments', function() {
            beforeEach(function() {
                view = new ConfirmAppointmentPopupView({
                    model: getAppointmentModelForSubmit({
                        clinicFriendlyLocationName: "Dr. Evan's Clinic friendly name",
                        clinicId: '123',
                        clinicName: 'MOCK CLINIC NAME 123',
                        secondaryStopCode: VIDEO_STOP_CODE,
                    }),
                    typeOfCareName: 'PRIMARY CARE',
                    notificationEmail: 'abc@edf.com',
                    elAfterClose: '.element-for-focus',
                });

                $('body').append('<a class="element-for-focus" href="#"></a>');
                view.render();
                $view = view.$el;
            });

            afterEach(function() {
                view.destroy();
                $('.element-for-focus').remove();
            });

            it('has a heading', function() {
                expect($view.find('h3.ui-title').text()).toEqual('Confirm Appointment');
            });

            it('has displays appointment summary and video appointment instructions', function() {
                var expectTime = '02/21/2017 @ 0930 EST\nType of Care: PRIMARY CARE';

                expect($view.find('.ui-content p:first-child').text()).toEqual('You are scheduling a Video Appointment for:');
                expect($view.find('.ui-content p:nth-child(2)').text()
                    .replace(/[\t\f\v]/g, '')).toEqual(expectTime);
                expect($view.find('.ui-content p:nth-child(3)').text()
                    .replace(/[\t\f\v]/g, '')).toEqual('Your video appointment link will be sent to:\nabc@edf.com');

                expect($view.find('.ui-content p:nth-child(4)').text()
                    .replace(/[\t\f\v]/g, '')).toEqual('For a Video Appointment, please remember:');
                expect($view.find('.ui-content ul li:first-child').text()
                    .trim()).toEqual('You will need to join the appointment from a computer, tablet, or smartphone with internet access');
                expect($view.find('.ui-content ul li:nth-child(2)').text()
                    .trim()).toEqual('The device you join with will need to have a camera and microphone');
                expect($view.find('.ui-content ul li:nth-child(3)').text()
                    .trim()).toEqual('The email address you have provided will be used to send a link that will allow you to join the appointment and receive appointment reminders');
            });
        });
    });

}
);
